/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Sounds;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.network.c2s.EnginePowerMessage;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.util.InterpolatedFloat;
import immersive_aircraft.util.Utils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class EngineAircraft
extends AircraftEntity {
    protected static final EntityDataAccessor<Float> ENGINE = SynchedEntityData.m_135353_(EngineAircraft.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> UTILIZATION = SynchedEntityData.m_135353_(EngineAircraft.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> LOW_ON_FUEL = SynchedEntityData.m_135353_(EngineAircraft.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final InterpolatedFloat engineRotation = new InterpolatedFloat();
    public final InterpolatedFloat enginePower = new InterpolatedFloat(20.0f);
    public float engineSpinUpStrength = 0.0f;
    public float engineSound = 0.0f;
    FuelState lastFuelState = FuelState.NEVER;
    public static final int TARGET_FUEL = 1000;
    public static final int LOW_FUEL = 900;
    private final int[] fuel = new int[this.getInventoryDescription().getSlots(VehicleInventoryDescription.SlotType.BOILER).size()];

    public GUI_STYLE getGuiStyle() {
        return GUI_STYLE.ENGINE;
    }

    public EngineAircraft(EntityType<? extends AircraftEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
    }

    protected SoundEvent getEngineStartSound() {
        return Sounds.ENGINE_START.get();
    }

    protected SoundEvent getEngineSound() {
        return Sounds.PROPELLER.get();
    }

    protected float getEnginePitch() {
        return 1.0f;
    }

    protected float getEngineReactionSpeed() {
        return 20.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENGINE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(UTILIZATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LOW_ON_FUEL, (Object)false);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.enginePower.setSteps(this.getEngineReactionSpeed() / this.getProperties().get(AircraftStat.ACCELERATION));
        this.enginePower.update(this.getEngineTarget() * (this.f_19798_ ? 0.1f : 1.0f));
        this.engineSpinUpStrength = Math.max(0.0f, this.engineSpinUpStrength + this.enginePower.getDiff() - 0.01f);
        if (this.f_19853_.m_5776_()) {
            this.engineRotation.update((this.engineRotation.getValue() + this.getEnginePower()) % 1000.0f);
        }
        if (!this.m_20160_() && this.getEngineTarget() > 0.0f) {
            this.setEngineTarget(0.0f);
        }
        if (this.f_19853_.f_46443_) {
            this.engineSound += this.getEnginePower() * 0.25f;
            if (this.engineSound > 1.0f) {
                this.engineSound -= 1.0f;
                if (this.isFuelLow()) {
                    this.engineSound -= (float)this.f_19796_.m_188503_(2);
                }
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getEngineSound(), this.m_5720_(), Math.min(1.0f, 0.25f + this.engineSpinUpStrength), (this.f_19796_.m_188501_() * 0.1f + 0.95f) * this.getEnginePitch(), false);
            }
        }
        if (this.fuel.length > 0 && !this.f_19853_.f_46443_) {
            for (float consumption = this.getFuelConsumption(); consumption > 0.0f && (consumption >= 1.0f || this.f_19796_.m_188501_() < consumption); consumption -= 1.0f) {
                for (int i = 0; i < this.fuel.length; ++i) {
                    if (this.fuel[i] <= 0) continue;
                    int n = i;
                    this.fuel[n] = this.fuel[n] - 1;
                }
            }
        }
        if (this.m_20160_()) {
            this.refuel();
            Entity i = this.m_6688_();
            if (i instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)i;
                float utilization = this.getFuelUtilization();
                if (utilization > 0.0f && this.isFuelLow()) {
                    if (this.lastFuelState != FuelState.LOW) {
                        player.m_5661_((Component)Component.m_237115_((String)("immersive_aircraft." + this.getFuelType() + ".low")), true);
                        this.lastFuelState = FuelState.LOW;
                    }
                } else if (utilization > 0.0f) {
                    this.lastFuelState = FuelState.FUELED;
                } else if (this.lastFuelState != FuelState.EMPTY) {
                    player.m_5661_((Component)Component.m_237115_((String)("immersive_aircraft." + this.getFuelType() + "." + (this.lastFuelState == FuelState.FUELED ? "out" : "none"))), true);
                    this.lastFuelState = FuelState.EMPTY;
                }
            }
        } else {
            this.lastFuelState = FuelState.NEVER;
        }
    }

    protected boolean isFuelLow() {
        if (!Config.getInstance().burnFuelInCreative && this.isPilotCreative()) {
            return false;
        }
        if (this.f_19853_.f_46443_) {
            return (Boolean)this.f_19804_.m_135370_(LOW_ON_FUEL);
        }
        boolean low = true;
        for (int i : this.fuel) {
            if (i <= 900) continue;
            low = false;
            break;
        }
        this.f_19804_.m_135381_(LOW_ON_FUEL, (Object)low);
        return low;
    }

    protected String getFuelType() {
        return "fuel";
    }

    float getFuelConsumption() {
        return this.getEngineTarget() * this.getProperties().get(AircraftStat.FUEL) * Config.getInstance().fuelConsumption;
    }

    private void refuel(int i) {
        ItemStack stack;
        int time;
        List<VehicleInventoryDescription.Slot> slots = this.getInventoryDescription().getSlots(VehicleInventoryDescription.SlotType.BOILER);
        while (this.fuel[i] <= 1000 && i < slots.size() && (time = Utils.getFuelTime(stack = this.getInventory().m_8020_(slots.get(i).index()))) > 0) {
            int n = i;
            this.fuel[n] = this.fuel[n] + time;
            Item item = stack.m_41720_();
            stack.m_41774_(1);
            if (!stack.m_41619_()) continue;
            Item remainingItem = item.m_41469_();
            this.getInventory().m_6836_(slots.get(i).index(), remainingItem == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)remainingItem));
        }
    }

    private void refuel() {
        for (int i = 0; i < this.fuel.length; ++i) {
            this.refuel(i);
        }
    }

    @Override
    protected void updateController() {
        this.m_146922_(this.m_146908_() - this.getProperties().get(AircraftStat.YAW_SPEED) * this.pressingInterpolatedX.getSmooth());
        if (!this.f_19861_) {
            this.m_146926_(this.m_146909_() + this.getProperties().get(AircraftStat.PITCH_SPEED) * this.pressingInterpolatedZ.getSmooth());
        }
        this.m_146926_(this.m_146909_() * (1.0f - this.getProperties().getAdditive(AircraftStat.STABILIZER)));
    }

    @Override
    protected void updateVelocity() {
        super.updateVelocity();
        if (this.f_19861_) {
            this.m_146926_((this.m_146909_() + this.getProperties().get(AircraftStat.GROUND_PITCH)) * 0.9f - this.getProperties().get(AircraftStat.GROUND_PITCH));
        }
    }

    public float getEnginePower() {
        return (float)((double)this.enginePower.getSmooth() * Math.sqrt(this.getFuelUtilization()));
    }

    public float getEngineTarget() {
        return ((Float)this.f_19804_.m_135370_(ENGINE)).floatValue();
    }

    public void setEngineTarget(float engineTarget) {
        if (this.getFuelUtilization() > 0.0f || engineTarget == 0.0f) {
            if (this.f_19853_.f_46443_) {
                if (this.getEngineTarget() != engineTarget) {
                    NetworkHandler.sendToServer(new EnginePowerMessage(engineTarget));
                }
                if (this.getFuelUtilization() > 0.0f && (double)this.getEngineTarget() == 0.0 && engineTarget > 0.0f) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getEngineStartSound(), this.m_5720_(), 1.0f, this.getEnginePitch(), false);
                }
            }
            this.f_19804_.m_135381_(ENGINE, (Object)Float.valueOf(engineTarget));
        }
    }

    public float getFuelUtilization() {
        if (Config.getInstance().fuelConsumption == 0.0f) {
            return 1.0f;
        }
        if (!Config.getInstance().burnFuelInCreative && this.isPilotCreative()) {
            return 1.0f;
        }
        if (this.f_19853_.f_46443_) {
            return ((Float)this.f_19804_.m_135370_(UTILIZATION)).floatValue();
        }
        int running = 0;
        for (int i : this.fuel) {
            if (i <= 0) continue;
            ++running;
        }
        float utilization = (float)running / (float)this.fuel.length * (this.isFuelLow() ? 0.75f : 1.0f);
        this.f_19804_.m_135381_(UTILIZATION, (Object)Float.valueOf(utilization));
        return utilization;
    }

    @Override
    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set("engine_rotation", this.engineRotation.getSmooth(tickDelta));
    }

    public static enum GUI_STYLE {
        NONE,
        ENGINE;

    }

    protected static enum FuelState {
        NEVER,
        EMPTY,
        FUELED,
        LOW;

    }
}

